
/*:
 * @target MZ
 * @plugindesc Skips the main menu and starts the game immediately.
 * @help This plugin will skip the main menu and start the game immediately.
 */

(() => {
    const _Scene_Boot_start = Scene_Boot.prototype.start;
    Scene_Boot.prototype.start = function() {
        _Scene_Boot_start.call(this);
        this.checkPlayerLocation();
        DataManager.setupNewGame();
        SceneManager.goto(Scene_Map);
    };

    Scene_Boot.prototype.checkPlayerLocation = function() {
        if ($dataSystem.startMapId === 0) {
            throw new Error('Player was not found. Please check if a starting position is set in the database.');
        }
    };
})();
